/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.problem;

import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.base.pa.system.RemoteConsoleSystem;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.p.pa.problem.SupportingSurveillanceInfo;
import com.ibm.hwmca.xfw.pa.problem.JournaledProblem;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import com.ibm.hwmca.xfw.panel.CaptionValuePairing;
import com.ibm.hwmca.xfw.panel.LocalizablePanelValue;
import com.ibm.hwmca.xfw.panel.LocalizableTimePanelValue;
import com.ibm.hwmca.xfw.panel.NonLocalizablePanelValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class PIProblem
extends JournaledProblem
implements Persistable {
    private static final String TRACE_MASKT = "PPAPIPRT";
    private static final String TRACE_MASKF = "PPAPIPRF";
    private static final String TRACE_MASKD = "PPAPIPRD";
    public static final String TEST_PROBLEM = "Test PI problem";
    Set associatedCECSystemSet = new HashSet();
    PASystem clusterSystem = null;
    PASystem calledHomeSystem = null;
    boolean surveillanceProblem = false;

    public PIProblem() {
        this("PI Problem");
    }

    public PIProblem(String description) {
        super(description);
        this.setGenerateAttention(false);
        if (description.equals(TEST_PROBLEM)) {
            this.setSkipVPD(true);
            this.setSkipRSF(true);
        }
    }

    public PIProblem(PersistentData data) throws PersistenceException {
        super(((PIProblemPersistentData)data).superClassPersistentData);
        if (((PIProblemPersistentData)data).srsPersistentData != null) {
            this.secondaryReportingSystem = (PASystem)PersistenceManager.getPersistenceManager().containedFormToObject(((PIProblemPersistentData)data).srsPersistentData);
        }
        if (((PIProblemPersistentData)data).csPersistentData != null) {
            this.clusterSystem = (PASystem)PersistenceManager.getPersistenceManager().containedFormToObject(((PIProblemPersistentData)data).csPersistentData);
        }
        if (((PIProblemPersistentData)data).chsPersistentData != null) {
            this.calledHomeSystem = (PASystem)PersistenceManager.getPersistenceManager().containedFormToObject(((PIProblemPersistentData)data).chsPersistentData);
        }
        this.linkPIPRemoteSystems();
        if (this.secondaryReportingSystem != null) {
            Trace.trace(TRACE_MASKD, "secondaryReportingSystem=" + this.secondaryReportingSystem);
        } else {
            Trace.trace(TRACE_MASKD, "secondaryReportingSystem=not set");
        }
        if (this.clusterSystem != null) {
            Trace.trace(TRACE_MASKD, "clusterSystem=" + this.clusterSystem);
        } else {
            Trace.trace(TRACE_MASKD, "clusterSystem=not set");
        }
        if (this.calledHomeSystem != null) {
            Trace.trace(TRACE_MASKD, "calledHomeSystem=" + this.calledHomeSystem);
        } else {
            Trace.trace(TRACE_MASKD, "calledHomeSystem=not set");
        }
    }

    public PersistentData getPersistentData() {
        PIProblemPersistentData persistentData = new PIProblemPersistentData();
        persistentData.superClassPersistentData = super.getPersistentData();
        if (this.secondaryReportingSystem != null) {
            persistentData.srsPersistentData = PersistenceManager.getPersistenceManager().objectToContainedForm(this.secondaryReportingSystem);
        }
        if (this.clusterSystem != null) {
            persistentData.csPersistentData = PersistenceManager.getPersistenceManager().objectToContainedForm(this.clusterSystem);
        }
        if (this.calledHomeSystem != null) {
            persistentData.chsPersistentData = PersistenceManager.getPersistenceManager().objectToContainedForm(this.calledHomeSystem);
        }
        return persistentData;
    }

    public void fromXML(Node valueNode) {
        super.fromXML(valueNode);
        this.linkPIPRemoteSystems();
    }

    private void linkPIPRemoteSystems() {
        Trace.trace(TRACE_MASKD, "--> linkPIPRemoteSystems");
        RemoteSystemManager rsm = RemoteSystemManager.getRemoteSystemManager();
        if (rsm != null) {
            RemoteSystem knownSys;
            if (this.secondaryReportingSystem != null && this.secondaryReportingSystem instanceof RemoteSystem) {
                knownSys = rsm.getKnownSystem((RemoteSystem)this.secondaryReportingSystem);
                if (knownSys != null) {
                    Trace.trace(TRACE_MASKD, "Associating secondaryReportingSystem with RemoteSystemManager reference [" + knownSys.getUniqueKey() + "]");
                    this.secondaryReportingSystem = knownSys;
                } else {
                    Trace.trace(TRACE_MASKT, "Couldn't find secondaryReportingSystem (" + this.secondaryReportingSystem + ") in RemoteSystemManager - this might be a problem!");
                }
            }
            if (this.clusterSystem != null && this.clusterSystem instanceof RemoteSystem) {
                knownSys = rsm.getKnownSystem((RemoteSystem)this.clusterSystem);
                if (knownSys != null) {
                    Trace.trace(TRACE_MASKD, "Associating clusterSystem with RemoteSystemManager reference [" + knownSys.getUniqueKey() + "]");
                    this.clusterSystem = knownSys;
                } else {
                    Trace.trace(TRACE_MASKT, "Couldn't find clusterSystem (" + this.clusterSystem + ") in RemoteSystemManager - this might be a problem!");
                }
            }
            if (this.calledHomeSystem != null && this.calledHomeSystem instanceof RemoteSystem) {
                knownSys = rsm.getKnownSystem((RemoteSystem)this.calledHomeSystem);
                if (knownSys != null) {
                    Trace.trace(TRACE_MASKD, "Associating calledHomeSystem with RemoteSystemManager reference [" + knownSys.getUniqueKey() + "]");
                    this.calledHomeSystem = knownSys;
                } else {
                    Trace.trace(TRACE_MASKT, "Couldn't find calledHomeSystem (" + this.calledHomeSystem + ") in RemoteSystemManager - this might be a problem!");
                }
            }
        }
        Trace.trace(TRACE_MASKD, "<-- linkPIPRemoteSystems");
    }

    public void setTrapEnterpriseID(String trapEnterpriseID) {
        this.getProblemData().add("pdc_TRAP_ENTERPRISE_ID", trapEnterpriseID);
    }

    public String getTrapEnterpriseID() {
        return (String)this.getProblemData().get("pdc_TRAP_ENTERPRISE_ID");
    }

    public void setHmcFailingAdapter(String failingAdapter) {
        this.getProblemData().add("pdc_HMC_FAILING_ADAPTER", failingAdapter);
    }

    public void getHmcFailingAdapter() {
        this.getProblemData().get("pdc_HMC_FAILING_ADAPTER");
    }

    public void setTrapKey(String trapKey) {
        this.getProblemData().add("pdc_TRAP_KEY", trapKey);
    }

    public String getTrapKey() {
        return (String)this.getProblemData().get("pdc_TRAP_KEY");
    }

    public void setTrapData(Map trapData) {
        if (trapData != null && trapData.size() > 0) {
            XMLEncodeableArrayList trapDataInfo = new XMLEncodeableArrayList("pdc_TRAP_DATA");
            Iterator i = trapData.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                trapDataInfo.add((String)e.getKey());
                trapDataInfo.add((String)e.getValue());
            }
            this.getProblemData().add("pdc_TRAP_DATA", trapDataInfo);
        }
    }

    public Map getTrapData() {
        HashMap trapData = null;
        XMLEncodeableArrayList trapDataInfo = (XMLEncodeableArrayList)this.getProblemData().get("pdc_TRAP_DATA");
        if (trapDataInfo != null && trapDataInfo.size() > 0) {
            trapData = new HashMap();
            for (int i = 0; i < trapDataInfo.size(); i += 2) {
                trapData.put(trapDataInfo.get(i), trapDataInfo.get(i + 1));
            }
        }
        return trapData;
    }

    public void setTrapCode(short trapCode) {
        this.getProblemData().add("pdc_TRAP_CODE", new Short(trapCode));
    }

    public short getTrapCode() {
        short retVal = 0;
        Short sTmp = (Short)this.getProblemData().get("pdc_TRAP_CODE");
        if (sTmp != null) {
            retVal = sTmp;
        }
        return retVal;
    }

    public String[] getPmrNotelog() {
        String[] notelog = null;
        XMLEncodeableArrayList notelogInfo = (XMLEncodeableArrayList)this.getProblemData().get("pdc_PMR_NOTELOG");
        if (notelogInfo != null && notelogInfo.size() > 0) {
            notelog = notelogInfo.toArray(new String[notelogInfo.size()]);
        }
        return notelog;
    }

    public void setPmrNoteLog(String[] notelog) {
        if (notelog != null && notelog.length > 0) {
            XMLEncodeableArrayList notelogInfo = new XMLEncodeableArrayList("pdc_PMR_NOTELOG");
            for (int i = 0; i < notelog.length; ++i) {
                if (notelog[i] == null) continue;
                notelogInfo.add(notelog[i]);
            }
            this.getProblemData().add("pdc_PMR_NOTELOG", notelogInfo);
        }
    }

    public boolean isStorageRequest() {
        boolean retVal = false;
        Boolean bTmp = (Boolean)this.getProblemData().get("pdc_PMR_STORAGE_REQUEST");
        if (bTmp != null) {
            retVal = bTmp;
        }
        return retVal;
    }

    public void setStorageRequest(boolean storageRequest) {
        this.getProblemData().add("pdc_PMR_STORAGE_REQUEST", new Boolean(storageRequest));
    }

    public void setEventSeverity(int evtSeverity) {
        this.getProblemData().add("pdc_EVENT_SEVERITY", "" + evtSeverity);
    }

    public String getEventSeverity() {
        return (String)this.getProblemData().get("pdc_EVENT_SEVERITY");
    }

    public void addAssociatedCECSystem(PASystem system) {
        this.associatedCECSystemSet.add(system);
    }

    public void addAssociatedCECSystem(List systemList) {
        Iterator listIter = systemList.iterator();
        while (listIter.hasNext()) {
            this.addAssociatedCECSystem((PASystem)listIter.next());
        }
    }

    public Set getAssociatedCECSystems() {
        return this.associatedCECSystemSet;
    }

    public void setSupportingSurvInfo(SupportingSurveillanceInfo ssi) {
        XMLEncodeableArrayList supportingInfo = null;
        supportingInfo = (XMLEncodeableArrayList)this.getProblemData().get("pdc_SUPPORTING_SURV_INFO");
        if (supportingInfo == null) {
            supportingInfo = new XMLEncodeableArrayList("pdc_SUPPORTING_SURV_INFO");
            supportingInfo.add(ssi);
            this.getProblemData().add("pdc_SUPPORTING_SURV_INFO", supportingInfo);
        } else {
            supportingInfo.add(ssi);
        }
    }

    public XMLEncodeableArrayList getSupportingSurvInfo() {
        return (XMLEncodeableArrayList)this.getProblemData().get("pdc_SUPPORTING_SURV_INFO");
    }

    public void setPartitionID(String partitionID) {
        this.getProblemData().add("pdc_PARTITION_ID", partitionID);
    }

    public String getPartitionID() {
        return (String)this.getProblemData().get("pdc_PARTITION_ID");
    }

    public void setPartitionName(String partitionName) {
        this.getProblemData().add("pdc_PARTITION_NAME", partitionName);
    }

    public String getPartitionName() {
        return (String)this.getProblemData().get("pdc_PARTITION_NAME");
    }

    public void setPartitionHostName(String partitionHostName) {
        this.getProblemData().add("pdc_PARTITION_HOST_NAME", partitionHostName);
    }

    public String getPartitionHostName() {
        return (String)this.getProblemData().get("pdc_PARTITION_HOST_NAME");
    }

    public void setPartitionOSType(String partitionOSType) {
        this.getProblemData().add("pdc_PARTITION_OS_TYPE", partitionOSType);
    }

    public String getPartitionOSType() {
        return (String)this.getProblemData().get("pdc_PARTITION_OS_TYPE");
    }

    public void setClusterSystem(PASystem system) {
        this.clusterSystem = system;
    }

    public PASystem getClusterSystem() {
        return this.clusterSystem;
    }

    public void setSwitchNetworkID(String switchNetworkID) {
        this.getProblemData().add("pdc_SWITCH_NETWORK_ID", switchNetworkID);
    }

    public String getSwitchNetworkID() {
        return (String)this.getProblemData().get("pdc_SWITCH_NETWORK_ID");
    }

    public void setNotificationType(LocalizableText type) {
        this.getProblemData().add("pdc_NOTIFICATION_TYPE", type);
    }

    public LocalizableText getNotificationType() {
        return (LocalizableText)this.getProblemData().get("pdc_NOTIFICATION_TYPE");
    }

    public void setNotificationStatus(LocalizableText status) {
        this.getProblemData().add("pdc_NOTIFICATION_STATUS", status);
    }

    public LocalizableText getNotificationStatus() {
        return (LocalizableText)this.getProblemData().get("pdc_NOTIFICATION_STATUS");
    }

    public void setCalledHomeSystem(PASystem system) {
        this.calledHomeSystem = system;
    }

    public PASystem getCalledHomeSystem() {
        return this.calledHomeSystem;
    }

    public void setSystemLogID(int slid) {
        this.getProblemData().add("pdc_SYSTEM_LOG_ID", slid + "");
    }

    public void setSystemLogID(String errorLogLabel) {
        this.getProblemData().add("pdc_SYSTEM_LOG_ID", errorLogLabel);
    }

    public String getSystemLogID() {
        return (String)this.getProblemData().get("pdc_SYSTEM_LOG_ID");
    }

    public void setErrorLogLabelID(String errorLogLabel) {
        this.getProblemData().add("pdc_ERROR_LOG_LABEL_ID", errorLogLabel);
    }

    public String getErrorLogLabelID() {
        return (String)this.getProblemData().get("pdc_ERROR_LOG_LABEL_ID");
    }

    public void setEEDFilename(String eedFilename) {
        this.getProblemData().add("pdc_EED_FILENAME", eedFilename);
    }

    public String getEEDFilename() {
        return (String)this.getProblemData().get("pdc_EED_FILENAME");
    }

    public void setEED(String eed) {
        this.getProblemData().add("pdc_EED", eed);
    }

    public String getEED() {
        return (String)this.getProblemData().get("pdc_EED");
    }

    public void setSequenceNumber(long SeqNum) {
        this.getProblemData().add("pdc_SEQUENCE_NUMBER", "" + SeqNum);
    }

    public String getSequencNumber() {
        return (String)this.getProblemData().get("pdc_SEQUENCE_NUMBER");
    }

    public void setPlatformLogID(int id) {
        this.getProblemData().add("pdc_PLATFORM_LOG_ID", id + "");
    }

    public String getPlatformLogID() {
        return (String)this.getProblemData().get("pdc_PLATFORM_LOG_ID");
    }

    public void setSubsystemID(int sysID) {
        this.getProblemData().add("pdc_SUBSYSTEM_ID", sysID + "");
    }

    public String getSubsystemID() {
        return (String)this.getProblemData().get("pdc_SUBSYSTEM_ID");
    }

    public void setSymptomString(String symptomString) {
        this.getProblemData().add("pdc_SYMPTOM_STRING", symptomString);
    }

    public String getSymptomString() {
        return (String)this.getProblemData().get("pdc_SYMPTOM_STRING");
    }

    public void setHMCLocale(List localeList) {
        this.getProblemData().add("pdc_HMC_LOCALE", localeList);
    }

    public String[] getHMCLocale() {
        List localeList = (List)this.getProblemData().get("pdc_HMC_LOCALE");
        if (localeList == null || localeList.size() == 0) {
            return null;
        }
        return localeList.toArray(new String[localeList.size()]);
    }

    public void setNlsMessages(List msgList) {
        this.getProblemData().add("pdc_NLS_MESSAGES", msgList);
    }

    public String[] getNlsMessages() {
        List msgList = (List)this.getProblemData().get("pdc_NLS_MESSAGES");
        if (msgList == null || msgList.size() == 0) {
            return null;
        }
        return msgList.toArray(new String[msgList.size()]);
    }

    public List getPanelData() {
        ArrayList<CaptionValuePairing> panelList = new ArrayList<CaptionValuePairing>();
        CaptionValuePairing cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7657"), new NonLocalizablePanelValue(Integer.toString(this.getProblemNumber())));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getPMH() != null ? new CaptionValuePairing(new BaseMessageText("XPA7658"), new NonLocalizablePanelValue(this.getPMH())) : new CaptionValuePairing(new BaseMessageText("XPA7658"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getRefcode() != null ? new CaptionValuePairing(new BaseMessageText("XPA7676"), new NonLocalizablePanelValue(this.getRefcode())) : new CaptionValuePairing(new BaseMessageText("XPA7676"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        if (this.getExtension() != null && this.getExtension().length() > 0) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7705"), new NonLocalizablePanelValue(this.getExtension()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        cvp1 = this.getSRC() != null ? new CaptionValuePairing(new BaseMessageText("XPA7617"), new NonLocalizablePanelValue(this.getSRC())) : new CaptionValuePairing(new BaseMessageText("XPA7617"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.isProblemClosed() ? new CaptionValuePairing(new BaseMessageText("XPA7659"), new LocalizablePanelValue(new BaseMessageText("XPA7675"))) : new CaptionValuePairing(new BaseMessageText("XPA7659"), new LocalizablePanelValue(new BaseMessageText("XPA7674")));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7655"), new LocalizableTimePanelValue(this.getFirstReportedTimestamp()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7656"), new LocalizableTimePanelValue(this.getLastReportedTimestamp()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        String sysName = null;
        if (this.getReportingRemoteMachineSystem() != null) {
            sysName = this.getReportingRemoteMachineSystem().getMOSystemName();
            if (sysName == null) {
                sysName = this.getReportingRemoteMachineSystem().getSystemName();
            }
            if (sysName == null) {
                sysName = "";
            }
        } else {
            sysName = "";
        }
        String reportNameMsg = null;
        String reportMTMSMsg = null;
        if (this.getReportingRemoteMachineSystem() != null && this.getReportingRemoteMachineSystem() instanceof RemoteMachineSystem) {
            reportNameMsg = "XPA7694";
            reportMTMSMsg = "XPA7697";
        }
        if (this.getReportingRemoteMachineSystem() != null && (this.getReportingRemoteMachineSystem() instanceof ConsoleSystem || this.getReportingRemoteMachineSystem() instanceof RemoteConsoleSystem)) {
            reportNameMsg = "XPA7695";
            reportMTMSMsg = "XPA7698";
        }
        if (reportNameMsg != null && sysName != null) {
            cvp1 = new CaptionValuePairing(new BaseMessageText(reportNameMsg), new NonLocalizablePanelValue(sysName));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        if (this.getReportingRemoteMachineSystem() != null && reportMTMSMsg != null) {
            cvp1 = new CaptionValuePairing(new BaseMessageText(reportMTMSMsg), new NonLocalizablePanelValue(this.getReportingRemoteMachineSystem().getMTMS()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        String failingSystemMsg = null;
        if (this.getFailingSystem() != null && this.getFailingSystem() instanceof RemoteMachineSystem) {
            failingSystemMsg = "XPA7700";
        }
        if (this.getFailingSystem() != null && (this.getFailingSystem() instanceof ConsoleSystem || this.getFailingSystem() instanceof RemoteConsoleSystem)) {
            failingSystemMsg = "XPA7701";
        }
        if (this.getFailingSystem() != null && failingSystemMsg != null) {
            cvp1 = new CaptionValuePairing(new BaseMessageText(failingSystemMsg), new NonLocalizablePanelValue(this.getFailingSystem().getMTMS()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        cvp1 = this.getServiceableEventText() != null ? new CaptionValuePairing(new BaseMessageText("XPA7635"), new NonLocalizablePanelValue(this.getServiceableEventText())) : new CaptionValuePairing(new BaseMessageText("XPA7635"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getEventSeverity() != null ? new CaptionValuePairing(new BaseMessageText("XPA7622"), new NonLocalizablePanelValue(this.getEventSeverity())) : new CaptionValuePairing(new BaseMessageText("XPA7622"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        if (this.getAssociatedCECSystems().isEmpty()) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7662"), new NonLocalizablePanelValue(""));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7663"), new NonLocalizablePanelValue(""));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        } else {
            Iterator assocSystemIter = this.getAssociatedCECSystems().iterator();
            while (assocSystemIter.hasNext()) {
                PASystem assocSystem = (PASystem)assocSystemIter.next();
                if (assocSystem == null) {
                    Trace.trace(TRACE_MASKD, "null assocSys - skip");
                    cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7662"), new NonLocalizablePanelValue(""));
                    cvp1.setDisplayMode(1);
                    panelList.add(cvp1);
                    cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7663"), new NonLocalizablePanelValue(""));
                    cvp1.setDisplayMode(1);
                    panelList.add(cvp1);
                    continue;
                }
                cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7662"), new NonLocalizablePanelValue(assocSystem.getMTMS()));
                cvp1.setDisplayMode(1);
                panelList.add(cvp1);
                sysName = assocSystem.getMOSystemName();
                if (sysName == null) {
                    sysName = assocSystem.getSystemName();
                }
                if (sysName == null) {
                    sysName = "";
                }
                cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7663"), new NonLocalizablePanelValue(sysName));
                cvp1.setDisplayMode(1);
                panelList.add(cvp1);
            }
        }
        cvp1 = this.getSecondaryReportingSystem() != null ? new CaptionValuePairing(new BaseMessageText("XPA7664"), new NonLocalizablePanelValue(this.getSecondaryReportingSystem().getMTMS())) : new CaptionValuePairing(new BaseMessageText("XPA7664"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getPartitionID() != null ? new CaptionValuePairing(new BaseMessageText("XPA7638"), new NonLocalizablePanelValue(this.getPartitionID())) : new CaptionValuePairing(new BaseMessageText("XPA7638"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getPartitionName() != null ? new CaptionValuePairing(new BaseMessageText("XPA7639"), new NonLocalizablePanelValue(this.getPartitionName())) : new CaptionValuePairing(new BaseMessageText("XPA7639"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getPartitionHostName() != null ? new CaptionValuePairing(new BaseMessageText("XPA7640"), new NonLocalizablePanelValue(this.getPartitionHostName())) : new CaptionValuePairing(new BaseMessageText("XPA7640"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getPartitionOSType() != null ? new CaptionValuePairing(new BaseMessageText("XPA7644"), new NonLocalizablePanelValue(this.getPartitionOSType())) : new CaptionValuePairing(new BaseMessageText("XPA7644"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getClusterSystem() != null ? new CaptionValuePairing(new BaseMessageText("XPA7632"), new NonLocalizablePanelValue(this.getClusterSystem().getMTMS())) : new CaptionValuePairing(new BaseMessageText("XPA7632"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getSwitchNetworkID() != null ? new CaptionValuePairing(new BaseMessageText("XPA7633"), new NonLocalizablePanelValue(this.getSwitchNetworkID())) : new CaptionValuePairing(new BaseMessageText("XPA7633"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getNotificationType() != null ? new CaptionValuePairing(new BaseMessageText("XPA7614"), new LocalizablePanelValue(this.getNotificationType())) : new CaptionValuePairing(new BaseMessageText("XPA7614"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getNotificationStatus() != null ? new CaptionValuePairing(new BaseMessageText("XPA7665"), new LocalizablePanelValue(this.getNotificationStatus())) : new CaptionValuePairing(new BaseMessageText("XPA7665"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7666"), new LocalizableTimePanelValue(this.getServiceableEventCreationTimestamp()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7642"), new NonLocalizablePanelValue(Integer.toString(this.getDuplicateCount())));
        cvp1.setDisplayMode(5);
        panelList.add(cvp1);
        if (this.getPrimaryAnalyzingConsoleSystem() != null) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7703"), new NonLocalizablePanelValue(this.getPrimaryAnalyzingConsoleSystem().getMTMS()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
            if (this.getPrimaryAnalyzingConsoleSystem() instanceof ConsoleSystem && (sysName = this.getPrimaryAnalyzingConsoleSystem().getMOSystemName()) == null) {
                sysName = this.getPrimaryAnalyzingConsoleSystem().getSystemName();
            }
            if (this.getPrimaryAnalyzingConsoleSystem() instanceof RemoteConsoleSystem && (sysName = ((RemoteConsoleSystem)this.getPrimaryAnalyzingConsoleSystem()).getRESystemName()) == null) {
                sysName = this.getPrimaryAnalyzingConsoleSystem().getSystemName();
            }
            if (sysName == null) {
                sysName = "";
            }
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7704"), new NonLocalizablePanelValue(sysName));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        cvp1 = this.getCalledHomeSystem() != null ? new CaptionValuePairing(new BaseMessageText("XPA7669"), new NonLocalizablePanelValue(this.getCalledHomeSystem().getMTMS())) : new CaptionValuePairing(new BaseMessageText("XPA7669"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(5);
        panelList.add(cvp1);
        cvp1 = this.getSystemLogID() != null ? new CaptionValuePairing(new BaseMessageText("XPA7630"), new NonLocalizablePanelValue(this.getSystemLogID())) : new CaptionValuePairing(new BaseMessageText("XPA7630"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(5);
        panelList.add(cvp1);
        cvp1 = this.getPlatformLogID() != null ? new CaptionValuePairing(new BaseMessageText("XPA7615"), new NonLocalizablePanelValue(this.getPlatformLogID())) : new CaptionValuePairing(new BaseMessageText("XPA7615"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(5);
        panelList.add(cvp1);
        cvp1 = this.getSubsystemID() != null ? new CaptionValuePairing(new BaseMessageText("XPA7618"), new NonLocalizablePanelValue(this.getSubsystemID())) : new CaptionValuePairing(new BaseMessageText("XPA7618"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(5);
        panelList.add(cvp1);
        cvp1 = this.getSymptomString() != null ? new CaptionValuePairing(new BaseMessageText("XPA7624"), new NonLocalizablePanelValue(this.getSymptomString())) : new CaptionValuePairing(new BaseMessageText("XPA7624"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(5);
        panelList.add(cvp1);
        String[] localeArray = this.getHMCLocale();
        if (localeArray != null) {
            for (int i = 0; i < localeArray.length; ++i) {
                cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7636"), new NonLocalizablePanelValue(localeArray[i]));
                cvp1.setDisplayMode(5);
                panelList.add(cvp1);
            }
        } else {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7636"), new NonLocalizablePanelValue(""));
            cvp1.setDisplayMode(5);
            panelList.add(cvp1);
        }
        String[] msgArray = this.getNlsMessages();
        if (msgArray != null) {
            for (int i = 0; i < msgArray.length; ++i) {
                cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7637"), new NonLocalizablePanelValue(msgArray[i]));
                cvp1.setDisplayMode(5);
                panelList.add(cvp1);
            }
        } else {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7637"), new NonLocalizablePanelValue(""));
            cvp1.setDisplayMode(5);
            panelList.add(cvp1);
        }
        XMLEncodeableArrayList supportingInfo = this.getSupportingSurvInfo();
        if (supportingInfo != null) {
            Iterator siI = supportingInfo.iterator();
            while (siI.hasNext()) {
                SupportingSurveillanceInfo ssi = (SupportingSurveillanceInfo)siI.next();
                String refcode = "";
                if (ssi.getRefcode() != null) {
                    refcode = ssi.getRefcode();
                }
                Object[] parms = new String[]{};
                if (ssi.getEndPointA() != null && ssi.getEndPointB() != null) {
                    parms = new String[]{ssi.getEndPointA().getMTMS(), ssi.getEndPointB().getMTMS(), ssi.getRefcode()};
                    cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7677"), new NonLocalizablePanelValue(new BaseMessageText("XPA7678", parms).toString()));
                    cvp1.setDisplayMode(1);
                    panelList.add(cvp1);
                    continue;
                }
                if (ssi.getEndPointA() == null && ssi.getEndPointB() == null) continue;
                parms = ssi.getEndPointA() != null ? new String[]{ssi.getEndPointA().getMTMS(), ssi.getRefcode()} : new String[]{ssi.getEndPointB().getMTMS(), ssi.getRefcode()};
                cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7677"), new NonLocalizablePanelValue(new BaseMessageText("XPA7679", parms).toString()));
                cvp1.setDisplayMode(1);
                panelList.add(cvp1);
            }
        }
        return panelList;
    }

    public boolean isSurveillanceProblem() {
        return this.surveillanceProblem;
    }

    public void setSurveillanceProblem(boolean b) {
        this.surveillanceProblem = b;
    }

    private static class PIProblemPersistentData
    implements PersistentData {
        private static final long serialVersionUID = 1L;
        public Object srsPersistentData = null;
        public Object csPersistentData = null;
        public Object chsPersistentData = null;
        public PersistentData superClassPersistentData = null;
        public int version = 1;

        private PIProblemPersistentData() {
        }
    }
}

